// Vicentaotv Studio UI logic
(function(){
  const byId = (id) => document.getElementById(id);
  const out = (id, text) => { byId(id).textContent = text; };
  const log = (id, obj) => { byId(id).textContent = JSON.stringify(obj, null, 2); };
  const baseInput = byId('baseUrl');
  const getBase = () => (baseInput?.value || '').trim();

  async function postJson(url, payload){
    const full = (getBase() ? getBase() : '') + url;
    const res = await fetch(full, { method:'POST', headers:{ 'Content-Type':'application/json' }, body: JSON.stringify(payload)});
    let data;
    try { data = await res.json(); }
    catch(e){ const txt = await res.text(); data = { success:false, error:'Resposta não é JSON', raw: txt, status: res.status }; }
    return data;
  }

  // TTS
  byId('ttsBtn').addEventListener('click', async () => {
    const text = byId('ttsText').value.trim();
    const voice = byId('ttsVoice').value.trim();
    const format = byId('ttsFormat').value.trim();
    if(!text){ alert('Informe um texto.'); return; }
    out('ttsStatus', 'Processando...');
    byId('ttsBtn').disabled = true;
    try {
      const resp = await postJson('/index.php?option=com_vicentaotv&task=tts.synthesize', { text, voice, format, provider:'azure' });
      log('ttsOut', resp);
      if(resp.success && resp.url){
        const audio = byId('ttsAudio');
        audio.src = resp.url;
        audio.style.display = 'block';
        audio.load();
      }
    } catch(e){ log('ttsOut', { error: String(e) }); }
    out('ttsStatus', '');
    byId('ttsBtn').disabled = false;
  });

  // Video
  byId('vidBtn').addEventListener('click', async () => {
    const prompt = byId('vidPrompt').value.trim();
    const workflow = byId('vidWorkflow').value.trim();
    if(!prompt){ alert('Informe um prompt.'); return; }
    out('vidStatus','Enviando para ComfyUI... (placeholder)');
    byId('vidBtn').disabled = true;
    try {
      const resp = await postJson('/index.php?option=com_vicentaotv&task=video.generate', { prompt, workflow });
      log('vidOut', resp);
      if(resp.success && resp.client_id){
        out('vidStatus','Solicitação criada. client_id=' + resp.client_id + ' (use Status para consultar)');
        byId('vidClientId').value = resp.client_id;
      } else {
        out('vidStatus','Erro: ' + (resp.error || 'desconhecido'));
      }
    } catch(e){ log('vidOut', { error: String(e) }); out('vidStatus','Erro na requisição'); }
    byId('vidBtn').disabled = false;
  });

  byId('vidStatusBtn').addEventListener('click', async () => {
    const clientId = byId('vidClientId').value.trim();
    if(!clientId){ alert('Informe client_id.'); return; }
    const resp = await postJson('/index.php?option=com_vicentaotv&task=video.status', { client_id: clientId });
    log('vidOut', resp);
    out('vidStatus', resp.status || '');
  });

  // Clone
  byId('cloneBtn').addEventListener('click', async () => {
    out('cloneStatus','Solicitação de clonagem (stub)');
    try {
      const resp = await postJson('/index.php?option=com_vicentaotv&task=clone.createVoice', { note: 'stub' });
      log('cloneOut', resp);
      out('cloneStatus', resp.success ? 'OK' : 'Erro: ' + (resp.error || ''));
    } catch(e){ log('cloneOut', { error: String(e) }); out('cloneStatus', 'Erro'); }
  });
})();
