<?php
defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Response\JsonResponse;

class VicentaotvControllerClone extends BaseController {
    public function createVoice() {
        $app = Factory::getApplication();
        $input = $app->input;
        $voiceName = $input->getString('name', 'voz_local');
        $api = rtrim($this->getParam('assistant_api_url', ''), '/');
        if (!$api) { $this->respond(['ok'=>false,'error'=>'assistant_api_url não configurado']); return; }
        $fileInfo = $input->files->get('audio', null, 'array');
        if (!$fileInfo || !isset($fileInfo['tmp_name'])) {
            $this->respond(['ok'=>false,'error'=>'Arquivo de áudio não enviado']);
            return;
        }
        $cfile = curl_file_create($fileInfo['tmp_name'], $fileInfo['type'] ?? 'audio/mpeg', $fileInfo['name'] ?? 'voice.mp3');
        $postData = ['name' => $voiceName, 'audio' => $cfile];
        $res = $this->postMultipart("{$api}/voice-clone", $postData);
        $this->respond($res);
    }
    private function getParam($key, $default=''){
        $params = ComponentHelper::getParams('com_vicentaotv');
        return $params->get($key, $default);
    }
    private function respond($data){
        $app = Factory::getApplication();
        echo new JsonResponse($data);
        $app->close();
    }
    private function postMultipart($url, $data){
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        $body = curl_exec($ch);
        $err = curl_error($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($err) return ['ok'=>false,'error'=>$err];
        $json = json_decode($body, true);
        if (!$json) return ['ok'=>false,'error'=>"HTTP $status", 'raw'=>$body];
        return $json;
    }
}
