<?php
declare(strict_types=1);

namespace Vicentaotv\Component\Vicentaotv\Site\Controller;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Http\HttpFactory;

class TtsController extends BaseController
{
    public function synthesize(): void
    {
        $app = Factory::getApplication();
        $in = $app->input;
        $text = trim((string)$in->getString('text'));
        $voice = (string)$in->getString('voice','pt-BR-FranciscaNeural');
        $format = (string)$in->getString('format','audio-24khz-160kbitrate-mono-mp3');
        $provider = (string)$in->getString('provider','azure');
        if ($text==='') { echo new JsonResponse(['success'=>false,'error'=>'Texto vazio'],400); return; }
        $params = ComponentHelper::getParams('com_vicentaotv');
        $media = JPATH_ROOT.'/media/com_vicentaotv/generated/audio';
        if(!is_dir($media)) @mkdir($media,0775,true);
        try {
            if ($provider==='azure') {
                $key=(string)$params->get('azure_key');
                $region=(string)$params->get('azure_region');
                if(!$key||!$region){ echo new JsonResponse(['success'=>false,'error'=>'Azure Speech não configurado'],400); return; }
                $http=HttpFactory::getHttp();
                $tokUrl='https://'.$region.'.api.cognitive.microsoft.com/sts/v1.0/issueToken';
                $tokRes=$http->post($tokUrl,'',['Ocp-Apim-Subscription-Key'=>$key,'Content-Length'=>'0']);
                $token=trim($tokRes->body);
                if($token===''){ echo new JsonResponse(['success'=>false,'error'=>'Falha ao obter token do Azure'],500); return; }
                $safeVoice=htmlspecialchars($voice,ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8');
                $safeText=htmlspecialchars($text,ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8');
                $ssml='<speak version="1.0" xml:lang="pt-BR"><voice name="'.$safeVoice.'">'.$safeText.'</voice></speak>';
                $ttsUrl='https://'.$region.'.tts.speech.microsoft.com/cognitiveservices/v1';
                $ttsRes=$http->post($ttsUrl,$ssml,[
                    'Authorization'=>'Bearer '.$token,
                    'Content-Type'=>'application/ssml+xml',
                    'X-Microsoft-OutputFormat'=>$format,
                    'User-Agent'=>'com_vicentaotv',
                ]);
                if($ttsRes->code>=400){ echo new JsonResponse(['success'=>false,'error'=>'Erro Azure TTS: '.$ttsRes->code,'body'=>$ttsRes->body],500); return; }
                $ext=strpos($format,'mp3')!==false?'mp3':(strpos($format,'ogg')!==false?'ogg':'wav');
                $name='tts_'.time().'_'.substr(md5($text.$voice),0,8).'.'.$ext;
                file_put_contents($media.'/'.$name,$ttsRes->body);
                $url=Uri::root().'media/com_vicentaotv/generated/audio/'.$name;
                echo new JsonResponse(['success'=>true,'url'=>$url,'voice'=>$voice,'format'=>$format]);
                return;
            }
            echo new JsonResponse(['success'=>false,'error'=>'Provedor não suportado: '.$provider],400);
        } catch(\Throwable $e){ echo new JsonResponse(['success'=>false,'error'=>$e->getMessage()],500); }
    }
}
